
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "../MachineInterface.h"

#include "../nr_lib/nr_lib.h"


NR_LIB_ATTACK_PAR     (paraSeekRate, "Fade Speed", "Fade Speed (half life in ms)")
NR_LIB_AMPLITUDE16_PAR(paraInit,     "Initial",    "Volume [initialise] (0=0%, 8000=100%, FFFE=~200%)")
NR_LIB_AMPLITUDE16_PAR(paraTarget,   "Target",     "Volume [target]     (0=0%, 8000=100%, FFFE=~200%)")


CMachineParameter const *pParameters[] = 
{ 
	// global
	&paraSeekRate,
	&paraInit,
	&paraTarget
};

#pragma pack(1)		

class gvals
{
public:
	word seek_rate;
	word initial;
	word target;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,								// type
	MI_VERSION,	
	0,										// flags
	0,										// min tracks
	0,										// max tracks
	3,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	NULL,
#ifdef _DEBUG
	"Ninereeds Fade v1.0(Debug build)",		// name
#else
	"Ninereeds Fade v1.0",					// name
#endif
	"Fade",								// short name
	"Steve Horne",							// author
	NULL
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);

private:
			
	

private:
    c_Decay_Simple  *f_Level;
	
	gvals gval;

};

DLL_EXPORTS

mi::mi()
{
	f_Level = NULL;

	GlobalVals = &gval;
//	AttrVals = (int *)&aval;
}

mi::~mi()
{
	if (f_Level != NULL)  {  delete f_Level;  }
}

void mi::Init(CMachineDataInput * const pi)
{
	f_Level = new c_Decay_Simple (pMasterInfo->SamplesPerSec);
}

void mi::Tick()
{
	f_Level->Tick (gval.seek_rate, gval.target, gval.initial);
}


bool mi::Work(float *psamples, int numsamples, int const mode)
{
	if ((mode & WM_READ) == 0)  {  return false;  }
	
	if (mode == WM_READ)
		return true;

	return f_Level->Multiply (psamples, numsamples);
}


